#version 330
#extension GL_EXT_gpu_shader4 : enable
// Jolly EASMod01.fsh  by   public_int_i

//https://www.shadertoy.com/view/WdKBDd
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.628318  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/*Ethan Alexander Shulman 2020 - xaloez.com
4k 60fps video https://www.youtube.com/watch?v=R3jy8kRJtYc
4k wallpaper xaloez.com/art/2020/Arch.jpg*/

#define EPS 1e-1
#define PI 3.14159265

mat2 r2(float a) {
	float s = sin(a), c = cos(a);
	return mat2(c,-s,s,c);
}

vec4 r4(float n) {
	#define R4P 1.1673039782614187
    return fract(.5+vec4(1./R4P,1./R4P/R4P,1./R4P/R4P/R4P,1./R4P/R4P/R4P/R4P)*n);
}
vec4 hash(vec4 a) {
    a = mod(abs(a),8273.97234);
    #define R4S(sw) floor(fract(.352347+dot(a,vec4(.001,.1,10.,100.).sw*2.23454))*20000.)
    return r4(R4S(xyzw)+R4S(yzwx)+R4S(wxyz)+R4S(zwxy));
}

float geo(vec3 p) {
	p.xy *= r2(p.z*.01+length(p.xy)*.02);
	p = mod(p+160.,vec3(16.,40.,16.))-vec3(8.,20.,8.);
	return min(length(p-vec3(0,15,0))-4.,
			max(abs(p.y)-14.,(length(vec2(sin(atan(p.x,p.z)*3.),length(p.xz)-3.5))-.4)))*.5;
}

vec3 hsvToRGB(vec3 hsv) {
	return mix(clamp(abs(mod(hsv.x*6.0+vec3(0.,4.,2.),6.)-3.0)-1.0,0.,1.),vec3(1),hsv.y)*hsv.z;
}

float twave(float x) {
	return x*2.-max(0.,x*4.-2.);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float time = iTime;
    vec2 uv = (gl_FragCoord.xy*2.-iResolution.xy)/iResolution.y;

	vec3 s = vec3(0);
	for (float ax = -1.; ax < 2.; ax++) {
		for (float ay = -1.; ay < 2.; ay++) {
			vec3 rp = vec3(15,0,0),
				rd = normalize(vec3(uv.xy+vec2(ax,ay)*.75/iResolution.y,.5)),
				//rd = normalize(vec3(uv.xy,.5)),
				c = vec3(0);
			rp.xy *= r2(time*-.01+1.2);
			rp.z += time;
			rp += rd*6.;
	
			for (int i = 0; i < 64; i++) { 
				float dst = geo(rp);
				if (dst <= 0.) break;
				rp += rd*(dst+EPS);
			}

			s += hsvToRGB(pow((sin(rp*.1)+cos(rp.yzx*.2)+2.)*.25,vec3(1,1,2.2)));
		}
	}
	gl_FragColor = vec4(s/9.,1.);
}